/*
 * Decompiled with CFR 0.152.
 */
package com.roguewave.chart.standard.v2_1.parts;

import com.roguewave.chart.core.v2_1.ChartGraphics;
import com.roguewave.chart.core.v2_1.ChartProperties;
import com.roguewave.chart.core.v2_1.DataModel;
import com.roguewave.chart.core.v2_1.graphics.Drawable;
import com.roguewave.chart.core.v2_1.graphics.Point3D;
import com.roguewave.chart.core.v2_1.graphics.Text2DDrawable;
import java.awt.Color;
import java.awt.Font;
import java.util.Vector;

public class Chart2DScale {
    Vector drawables_;

    public Chart2DScale(ChartProperties chartProperties, DataModel dataModel) {
        Font font = (Font)chartProperties.getProperty("ScaleFont", null);
        Color color = (Color)chartProperties.getProperty("ScaleLabelColor", Color.black);
        this.drawables_ = new Vector();
        int n = dataModel.getColumnCount();
        double d = -((double)n) / 2.0 + 0.5;
        int n2 = 0;
        while (n2 < n) {
            String string = dataModel.getColumnLabel(n2);
            if (string == null) {
                System.err.println("column label " + n2 + " is null!");
            } else {
                Point3D point3D = new Point3D(d, 0.0, 0.0);
                Text2DDrawable text2DDrawable = new Text2DDrawable(string, point3D, 0, font, color);
                this.drawables_.addElement(text2DDrawable);
                d += 1.0;
            }
            ++n2;
        }
    }

    public void add2DTo(ChartGraphics chartGraphics) {
        int n = 0;
        while (n < this.drawables_.size()) {
            chartGraphics.add2DDrawable((Drawable)this.drawables_.elementAt(n));
            ++n;
        }
    }
}

